/**
 * php_dhtml
 * Copyright (C) 2004-2005  Eric Colinet <ecolinet - gmail - com>
 * http://wildphp.free.fr/wiki/doku.php?id=php_dhtml:index
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __PHP_DHTML_H
# define __PHP_DHTML_H

#include "php.h"
#include "ext/standard/php_standard.h"

extern zend_module_entry dhtml_module_entry;
#define phpext_dhtml_ptr &dhtml_module_entry

#ifdef PHP_DHTML_EXPORT
# define PHP_DHTML_API __declspec(dllexport)
#else
# define PHP_DHTML_API
#endif

ZEND_MINIT_FUNCTION(dhtml);
ZEND_MSHUTDOWN_FUNCTION(dhtml);
ZEND_RINIT_FUNCTION(dhtml);
ZEND_RSHUTDOWN_FUNCTION(dhtml);
ZEND_MINFO_FUNCTION(dhtml);

PHP_FUNCTION(dhtml_create);
PHP_FUNCTION(dhtml_get_event);
PHP_FUNCTION(dhtml_set);
PHP_FUNCTION(dhtml_get);
PHP_FUNCTION(dhtml_get_id);
PHP_FUNCTION(dhtml_get_desktop_size);

/* 
ZEND_BEGIN_MODULE_GLOBALS(dhtml)
	int   global_value;
	char *global_string;
ZEND_END_MODULE_GLOBALS(dhtml)

#ifdef ZTS
#define DHTML_G(v) TSRMG(dhtml_globals_id, zend_dhtml_globals *, v)
#else
#define DHTML_G(v) (dhtml_globals.v)
#endif
*/

#endif	/* PHP_DHTML_H */
