<?php
/**
 * php_dhtml
 * Copyright (C) 2004-2005  Eric Colinet <ecolinet - gmail - com>
 * http://wildphp.free.fr/wiki/doku.php?id=php_dhtml:index
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

include 'dhtml.inc';

/* Resource file path - the place to look for html and images files (usefull to enable themes) */
$GLOBALS['WINAPP_RC_PATH']= 'rc/';

/* Static winApp member - Transformation type (default: null) */
$GLOBALS['WINAPP_TR']= null;

/* Static winApp member - Transformation param (default: null) */
$GLOBALS['WINAPP_TR_PARAM']= null;

/**
 * winApp Base class
 */
class winApp extends dhtml {
	var $toolbar= null;

	function winApp($title='Win App', $page=false, $visible=true, $size='640x480') {
		if( !$page ) $page= _f($GLOBALS['WINAPP_RC_PATH'].'winapp.htm');
		parent::dhtml($title, $page, $visible, $size);

		$this->toolbar= &new ToolBar;
		if( count($GLOBALS['dhtml_class_wnds'])==1 ) // First window
			sleep(1); // Horrible Hack (tm) - let MFC the time to initialize - this is a bug that I'll have to handle in the extension
	}

	/**
	 * Page loading
	 */
	function on_page_load($url) {
		$this->draw_toolbar();
		$this->id_html('toolBar', $this->toolbar->build_toolbar());
	}

	function draw_toolbar() {
		$this->id_html('toolBar', $this->toolbar->build_toolbar());
	}
	
	function set_status($string) {
		$this->id_html('statusBar', $string);
	}

	function set_warning($text) {
		$html= '<img src="'._f('images/attention.gif').'">&nbsp;'.$text;
		$this->set_status($html);
	}

	function on_close() {
		parent::on_close();
	}
}


/**
 * MessageBox Class 
 */
class MessageBox extends dhtml {
	var $title;
	var $text;
	var $parent= false;
	
	function MessageBox( &$parent, $text, $title='Message Box', $icon=false, $size='200x150') {
		parent::dhtml($title, _f($GLOBALS['WINAPP_RC_PATH'].'about.htm'), true, $size);
		$this->text= $text;
		$this->title= $title;
		$this->icon= $icon;
		if( is_object($parent) ) {
			$this->parent= $parent;
			$parent->disable();
		}
	}
	
	function on_init() {
		$this->handles_click('close');
	}

	function on_page_load($url) {
		if( !$this->icon ) $icon= '&nbsp;';
		else $icon= '<img src="'.$this->icon.'" border="0">';

		$html= <<<EOHTML
	<table width="100%" height="100%" border="0">
		<tr>
			<!-- Logo -->
			<td valign="top">
				$icon
			</td>
			<!-- Text -->
			<td align="center">
				{$this->text}
			</td>
		</tr>
		<tr><td colspan="2" align="center"><input type="button" id="close" value="Ok"></td></tr>
	</table>
EOHTML;
		$this->id_html('window', $html);
	}

	function on_cancel() { $this->on_close(); }
	function on_ok() { $this->on_close(); }
	function on_click_close() { $this->on_close(); }

	function on_close() {
		if( $this->parent ) $this->parent->enable();
		parent::on_close();
	}
}

/**
 * HTML Toolbar builder - make use of layer.js functions
 */
class ToolBar {
	var $toolbar= array();

	function toolbar_empty() {
		$this->toolbar= array();	
	}

	function add_button($id, $text, $image=false, $struct= false) {
		$this->toolbar[]= array( $id, $text, $image, $struct );
	}

	function build_menu($name, $struct, $visible=false,$addstyle='') {
		$html= '<div id="'.$name.'" class="menu" ';
		if( !$visible ) {
			$html.= 'onClick="toggleLayer(this)" ';
			$html.= "onMouseOut=\"timeout_id= setTimeout('hideLayer($name)', 500);\" ";
			$html.= 'onMouseOver="clearTimeout(timeout_id)" ';
		}
		else $html.= ' style="visibility:visible;'.$addstyle.'"';
		$html.= '>';
		foreach( $struct as $key => $elm ) {
			if( $elm=='-' ) $html.= '<div class="menu_item"><hr/></div>';
			else
				$html.= '<div id="'.$key.'" class="menu_item" onMouseOver="this.className=\'menu_item_over\'" onMouseOut="this.className=\'menu_item\'" onClick="window.location=\'#'.$key.'\'">'.$elm.'</div>';
		}
		$html.= '</div>';
		return $html;		
	}


	// id, text, image, menu - all fields can be null
	// type= normal || big
	function build_button($button, $class='button') {
		list($id, $text, $image, $struct)= $button;
		$attr= 'id="'.$id.'" class="'.$class.'" onMouseOver="this.className=\''.$class.'_over\'" onMouseOut="this.className=\''.$class.'\'" onMouseDown="this.className=\''.$class.'_click\'" onMouseUp="this.className=\''.$class.'_over\'"';
		if( is_array($struct) ) {
			$name= 'sub_'.$id;
			$attr.= ' onclick="toggleLayer(\''.$name.'\', this, \'relative\')"';
			$html.= $this->build_menu( $name, $struct );
		}
		else
			$attr.= ' onClick="hideVisible(); window.location=\'#'.$id.'\'"';
		if( $text || $image ) $html.= '<span '.$attr.'>'.($image?'<img border="0" align="Absmiddle" src="'.$image.'"/>':'').($text?'&nbsp;'.$text.'&nbsp;':'').'</span>';
		return $html;
	}

	function build_toolbar() {
		$html= '';
		foreach( $this->toolbar as $button ) {
			$html.= $this->build_button($button, 'button_big');
		}
		return $html;
	}
}


/**
 * About PHP Box
 */
function about_php($parent=null) {
	new MessageBox($parent, 'This software contain PHP freely available at http://www.php.net.', 'About PHP', _f('images/php-icon.png'));
}


/**
 * Make file names translation.
 * Depends on winApp::TR & winApp::TR_PARAM.
 * Usefull to create a package (see the wiki for details).
 */
function _f($file, $tr=false) {
	if( $tr==false ) $tr= $GLOBALS['WINAPP_TR'];
	if( !$tr ) return $file;
	$func= '_f_'.$tr;
	if( function_exists($func) ) return $func($file);
	trigger_error("'$func file transformation function '$func' doesn't exists", E_USER_WARNING);
	return $file; // ??
}


?>