<?php
/**
 * php_dhtml
 * Copyright (C) 2004-2005  Eric Colinet <ecolinet - gmail - com>
 * http://wildphp.free.fr/wiki/doku.php?id=php_dhtml:index
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * Default debug mode
 */
if( !defined('DHTML_DEBUG') ) define('DHTML_DEBUG', 0 );

/**
 * Static DHTML Member debug - debug on/off
 */
$GLOBALS['dhtml_class_debug']= DHTML_DEBUG;

/**
 * Static DHTML Member wnds - the list of all windows
 */
$GLOBALS['dhtml_class_wnds']= array();

/**
 * Static DHTML Member return_code - the return code of exit
 */
$GLOBALS['dhtml_class_return_code']= 0;

/**
 * Static DHTML Member wnd_messages - Inter-windows messages
 */
$GLOBALS['dhtml_class_wnd_messages']= array();


/**
 * dhtml class - a wrapper class for the php_dhtml extension.
 */
class dhtml {
	/**
	 * php_dhtml resource
	 */
	var $wnd;

	/**
	 * Window id
	 */
	var $id;

	/**
	 * wether if the window have been closed
	 * @todo implement it on php_dhtml
	 */
	var $closed;

	/**
	 * TMP file - used by load_string
	 * @todo find a way to unlink it automatically (register_shutdown_function for PHP4/_destruct for PHP5)
	 */
	var $tmp_file;

	/**
	  * Wrappers
	  */
	function dhtml_create() { return dhtml_create(); }
	function dhtml_get_id($wnd) { return dhtml_get_id($wnd); }
	function dhtml_set($wnd, $what, $value, $extra) { return dhtml_set($wnd, $what, $value, $extra); }
	function dhtml_get($wnd, $what, $value) { return dhtml_get($wnd, $what, $value); }
	function dhtml_get_event($wait) { return dhtml_get_event($wait); }
	function dhtml_is_closed($wnd) { return dhtml_is_closed($wnd); }
	

	function dhtml($title='', $page= false, $show=true, $size=null) {
		$this->wnd= $this->dhtml_create();
		$this->id= $this->dhtml_get_id($this->wnd);
		$this->Log("Created (".get_class($this).", id: $this->id)");

		$this->closed= 0;
		$GLOBALS['dhtml_class_wnds'][$this->id]= &$this;

		if( $size ) $this->size( $size );
		if( $title ) $this->set_title($title);
		if( $show ) $this->show();
		if( $page ) $this->load_rc($page);
	}


	/************************
		php_dhtml get/set wrappers
	************************/

	function _set($what, $value='', $extra=null) {
		$this->Log("SET '$what'\t'$value'\t'$extra'\n");
		$ret= $this->dhtml_set($this->wnd, $what, $value, $extra);
		if( !$ret ) $this->Error("set $what failed", '_set');
		return $ret;
	}

	function _get($what, $value='') {
		$result= $this->dhtml_get($this->wnd, $what, $value);
		$this->Log("GET '$what'\t'$value'\t=> '$result'");
		return $result;
	}


	/********************
	  Browser Window control
	*********************/
	
	function show() {
		return $this->_set( 'show');
	}

	function hide() {
		return $this->_set( 'hide');
	}

	function focus() {
		return $this->_set( 'focus');
	}

	function minimize() {
		return $this->_set( 'minimize');
	}

	function maximize() {
		return $this->_set( 'maximize');
	}

	function restore() {
		return $this->_set( 'restore');
	}

	function size($x, $y=false) {
		if( !$y ) 
			return $this->_set( 'size', "$x" ); // ie: $x='640x480'
		else
			return $this->_set( 'size', "{$x}x{$y}" ); // ie: $x=640 $y=480
	}

	function move($x, $y) {
		return $this->_set( 'move', "{$x}x{$y}" );
	}

	function close() {
		$this->closed= 1;
		return $this->_set( 'close');
	}
	
	function enable() {
		return $this->_set('enable');
	}

	function disable() {
		return $this->_set('disable');
	}

	function caption($on=true) {
		return $this->_set('caption', $on?1:0);
	}

	function border($on=true) {
		return $this->_set('border', $on?1:0);
	}

	function maximizebox($on=true) {
		return $this->_set('maximizebox', $on?1:0);
	}

	function minimizebox($on=true) {
		return $this->_set('minimizebox', $on?1:0);
	}

	function sysmenu($on=true) {
		return $this->_set('sysmenu', $on?1:0);
	}

	function sizebox($on=true) {
		return $this->_set('sizebox', $on?1:0);
	}

	function dlgframe($on=true) {
		return $this->_set('dlgframe', $on?1:0);
	}

	function appwindow($on=true) {
		return $this->_set('appwindow', $on?1:0);
	}

	function clientedge($on=true) {
		return $this->_set('clientedge', $on?1:0);
	}

	function toolwindow($on=true) {
		return $this->_set('toolwindow', $on?1:0);
	}

	function topmost($on=true) {
		return $this->_set('topmost', $on?1:0);
	}

	function windowedge($on=true) {
		return $this->_set('windowedge', $on?1:0);
	}

	function redraw() {
		return $this->_set('redraw');
	}


	/**
	 * load_url wrapper - Try to help using it
	 */
	function load_rc($url) {
		$this->Log("Load_rc $url");

		/* c: d: file:, http:, mhtml: and others */
		if( ereg('^[a-z]+:', $url) ) return $this->load_url( $url );

		/* So is it a file system file ? */
		if( !file_exists($url) ) return $this->Error("'$url' doesn't exists", 'load_rc');

		return $this->load_url(realpath($url));
	}

	/**
	 * Load an url - use load_rc instead
	 * Be sure to specify a full path name when requesting a file - or use load_rc.
	 */
	function load_url($url) {
		return $this->_set( 'url', $url );
	}

	/**
	  * Load a default template - you can use the id 'content' to access the body of the default page
	  */
	function load_default() {
		return $this->_set('load_default');
	}

	/**
	 * Reload the current url
	 */
	function reload() {
		return $this->_set('reload');
	}

	/************************************************************
		set or retrieve (depending of the number of arguments) an HTML id property
	************************************************************/

	/**
	 * get/set a tag's 'inner' HTML code.
	 * innerHTML: the Code that is between the opening and the ending tags.
	 * IE then parse the HTML code to display it.
	 */
	function id_html($id) {
		if( func_num_args()>1 ) { $v= func_get_arg(1); return $this->_set( 'id_html', $id, $v ); }
		return $this->_get( 'id_html', $id );
	}

	/**
	 * get/set a tag's attribute 'value' (ie: <input name=".." value="..">)
	 */
	function id_value($id) {
		if( func_num_args()>1 ) { $v= func_get_arg(1); return $this->_set( 'id_value', $id, $v ); }
		return $this->_get( 'id_value', $id );
	}

	/**
	 * get/set a tag's 'inner' TEXT.
	 * Mostly the same as id_html but the TEXT is not parsed by IE.
	 */
	function id_text($id) {
		if( func_num_args()>1 ) { $v= func_get_arg(1); return $this->_set( 'id_text', $id, $v ); }
		return $this->_get( 'id_text', $id );
	}

	/**
	 * get/set a tag's 'outer' HTML. The same as id_html but also include the tag contents.
	 */
	function id_outer_html($id) {
		if( func_num_args()>1 ) { $v= func_get_arg(1); return $this->_set( 'id_outer_html', $id, $v ); }
		return $this->_get( 'id_outer_html', $id );
	}

	/**
	 * get/set a 'A' tag's attribute 'HREF' (ie: <a href="...">Text</a>).
	 */
	function id_a_href($id) {
		if( func_num_args()>1 ) { $v= func_get_arg(1); return $this->_set( 'id_a_href', $id, $v ); }
		return $this->_get( 'id_a_href', $id );
	}

	/**
	 * get/set a 'A' tag's attribute 'target'  (ie <a href="..." target="...">Text</a>).
	 * Please note that frames and iframes are not supported at this time by php_dhtml (but it should!).
	 */
	function id_a_target($id) {
		if( func_num_args()>1 ) { $v= func_get_arg(1); return $this->_set( 'id_a_target', $id, $v ); }
		return $this->_get( 'id_a_target', $id );
	}

	/**
	 * get/set a 'IMG' tag's 'SRC' (ie: <img src="...">).
	 */
	function id_img_src($id) {
		if( func_num_args()>1 ) { $v= func_get_arg(1); return $this->_set( 'id_img_src', $id, $v ); }
		return $this->_get( 'id_img_src', $id );
	}

	/**
	 * get/set a 'FRAME' or 'IFRAME' tag's 'SRC' attribute (ie: <iframe src="...">)
	 * Please note that frames and iframes are not supported at this time by php_dhtml (but it should!).
	 */
	function id_frame_src($id) {
		if( func_num_args()>1 ) { $v= func_get_arg(1); return $this->_set( 'id_frame_src', $id, $v ); }
		return $this->_get( 'id_frame_src', $id );
	}



	/****************************
	  get/set DHTML Window propeties  
	****************************/

	/**
	 * Change the title of the window
	 */
	function set_title($title) {
		return $this->_set( 'title', $title );
	}
	
	/**
	 * Get the current window title
	 */
	function get_title($title) {
		return $this->_get( 'title' );
	}

	/**
	 * Ask the window to show or hide toolbars (default: Off).
	 * @param $on=true can also be false but also 'flat' to have a flat style scrollbar (nice one try it).
	 */
	function set_scrollbar($on=true) {
		return $this->_set( 'scrollbar', $on?$on:0 );
	}

	/**
	 * Display the IE control with a 3D look or not (a border).
	 */
	function set_3d_look($on=true) {
		return $this->_set( '3d_look', $on?'on':0 );
	}

	/**
	 * Define a timer event 'id' to be trown by the window each 'timeout' msec.
	 */
	function set_timer($id, $timeout) {
		return $this->_set('timer', $id, $timeout);
	}

	/**
	 * Kill a previously define timer.
	 * Same as set_timer($id, 0).
	 */
	function kill_timer($id) {
		return $this->_set('timer', $id, 0);
	}

	/***********************************************************************************
	  handles_* functions ask the dhtml window to fire an event for a particular HTML id or for an HTML class
	************************************************************************************/

	function handles_click($id, $is_class=false) {
		return $this->_set('event_click', $id, $is_class);
	}

	function handles_dblclick($id, $is_class=false) {
		return $this->_set('event_dblclick', $id, $is_class);
	}

	function handles_ctx_menu($id, $is_class=false) {
		return $this->_set('event_ctxmenu', $id, $is_class);
	}

	function handles_keypress($id, $is_class=false) {
		return $this->_set('event_keypress', $id, $is_class);
	}

	function handles_keydown($id, $is_class=false) {
		return $this->_set('event_keydown', $id, $is_class);
	}

	function handles_keyup($id, $is_class=false) {
		return $this->_set('event_keyup', $id, $is_class);
	}

	function handles_mouseout($id, $is_class=false) {
		return $this->_set('event_mouseout', $id, $is_class);
	}

	function handles_mouseover($id, $is_class=false) {
		return $this->_set('event_mouseover', $id, $is_class);
	}

	function handles_mousewheel($id, $is_class=false) {
		return $this->_set('event_mousewheel', $id, $is_class);
	}

	function handles_focusin($id, $is_class=false) {
		return $this->_set('event_focusin', $id, $is_class);
	}

	function handles_focusout($id, $is_class=false) {
		return $this->_set('event_focusout', $id, $is_class);
	}


	/************************
	  Inter-windows messages
	************************/

	/**
	 * [STATIC] Send $message to the window $id 
	 */
	function wnd_msg( $id, $message, $data ) {
		array_push($GLOBALS['dhtml_class_wnd_messages'], array($id, $message, $data));
	}


	/**********************
	  Default event handlers 
	**********************/
	
	/**
	 * close event handler
	 */
	function on_close() {
		//$this->load_default(); // Fix strange bug from using jsdomenu (?!?) (Not with 6.0.2800.1106 on NT)
		return $this->close();
	}

	/**
	 * Inter-window message handler
	 */
	function on_wnd_msg($msg, $data) {
		$this->Log("Window message received (and ignored): $msg");
	}

	/**
	 * [PRIVATE] Current window event handler - try to call self::on_$event_type if it exists, also handle event_close from the window
	 */
	function _event_handler($evt) {
		switch( $evt->type ) {
			case 'event_click':
			case 'event_dblclick':
			case 'event_ctxmenu':
			case 'event_keypress':
			case 'event_keydown':
			case 'event_keyup':
			case 'event_mouseout':
			case 'event_mouseover':
			case 'event_mousewheel':
			case 'event_focusin':
			case 'event_focusout':
				$meth_name= 'on_'.substr($evt->type, 6).'_'.$evt->value; // ie: on_{type}_{id} ex: on_click_button1
				$meth_name2= 'on_'.substr($evt->type, 6); // ie: on_{type} ex: on_click
			break;

			case 'event_ok':
			case 'event_cancel':
			case 'event_close':
				$meth_name= 'on_'.substr($evt->type, 6);
			break;

			case 'init':
			case 'page_load':
			case 'page_unload':
			case 'timer':
				$meth_name= 'on_'.$evt->type;
			break;

			case 'request':
				// Always call on request if it is defined - If it returns 0 => try on_command_{id} then on_command
				$handled= 0;
				if( method_exists($this, 'on_request') ) { 
					$this->Log("Call ".get_class($this).'::on_request');
					$handled= call_user_method('on_request', $this, $evt->value, $evt->extra);
				}
				if( !$handled ) {
					$pos= strpos($evt->value, "#");
					if( $pos!==false && $pos+1!=strlen($evt->value) ) {
						$cmd= substr($evt->value, $pos+1);
						$meth_name= 'on_command_'.$cmd;
					}
					$meth_name2= 'on_command';

					$evt->extra= $evt->value;
					$evt->value= $cmd;
				}
			break;
		}

		$retval= 0;
		if( method_exists($this, $meth_name) ) {
			$this->Log("Call ".get_class($this).'::'.$meth_name);
			$retval= call_user_method($meth_name, $this, $evt->value, $evt->extra);
		}
		if( $meth_name2 && method_exists($this, $meth_name2) ) {
			$this->Log("Call ".get_class($this).'::'.$meth_name2);
			$retval= call_user_method($meth_name2, $this, $evt->value, $evt->extra);
		}
		
		return $retval;
	}


	/**
	 * [STATIC] Exit the event loop and close all windows
	 */
	function close_all($code=0) {
		$GLOBALS['dhtml_class_return_code']= $code;
		$keys= array_keys($GLOBALS['dhtml_class_wnds']);
		for( $i= 0; $i<count($keys); $i++ )
			$GLOBALS['dhtml_class_wnds'][$keys[$i]]->close();
		return $this->_set( 'close');
	}


	/**
	 * [STATIC] Event loop for all windows
	 */
	function run() {
		do {
			/* Handle inter-windows messages */
			while( $wnd_msg= array_shift($GLOBALS['dhtml_class_wnd_messages']) ) {
				print_r($wnd_msg);
				list( $id, $msg, $data )= $wnd_msg;

				/* Search wnd */
				if( isset($GLOBALS['dhtml_class_wnds'][$id]) ) { 
					method_exists($GLOBALS['dhtml_class_wnds'][$id], 'on_wnd_msg');
					$result= $GLOBALS['dhtml_class_wnds'][$id]->on_wnd_msg($msg, $data);
				}
				else
					dhtml::Log("DHTML Window not found: $id");
			}

			dhtml::Log("Waiting for event");
			
			// PHP4 Limitation (no self keyword)
			if( $this ) $evt= $this->dhtml_get_event(1); // Wait for event
			else $evt= dhtml::dhtml_get_event(1); // Wait for event

			
				dhtml::Log("wnd='{$evt->id}' type='{$evt->type}' ".($evt->value?"value='{$evt->value}'":''). ($evt->extra?"extra='{$evt->extra}'":''));
			
			$result= 0;

			/* Search wnd */
			if( isset($GLOBALS['dhtml_class_wnds'][$evt->id]) )
				$result= $GLOBALS['dhtml_class_wnds'][$evt->id]->_event_handler($evt);
			else dhtml::Log("DHTML Window not found: $evt->id");

			/* Search closed windows */
			$keys= array_keys($GLOBALS['dhtml_class_wnds']);
			foreach( $keys as $index ) {
				$wnd= &$GLOBALS['dhtml_class_wnds'][$index];
				if( $wnd->closed ) {
					dhtml::Log("{$wnd->id} Is closed");
					unset($GLOBALS['dhtml_class_wnds'][$index]);
				}
			}
			
			dhtml::Log(count($GLOBALS['dhtml_class_wnds'])." windows left");
		} while( count($GLOBALS['dhtml_class_wnds']) );

		return $GLOBALS['dhtml_class_return_code'];
	}


	
	/************
	   Error/Debug
	*************/

	function Error($txt, $method='') {
		trigger_error('['.(isset($this)?get_class($this).'::'.($method?$method:'').'/'.$this->id:'dhtml').'] '.rtrim($txt), E_USER_WARNING);
		if( isset($this) ) $this->Log($txt);
		else dhtml::Log($txt);
		return false;
	}

	function Log($txt) {
		if( $GLOBALS['dhtml_class_debug'] ) 
			echo '['.(isset($this)?get_class($this).'/'.$this->id:'dhtml').'] '.rtrim($txt)."\n";
	}
}

?>