//========================================================================
//       Embeding a PHP source into a Windows executable file
//
//       Author: Eric Colinet <e dot colinet at laposte dot net>
//       http://wildphp.free.fr/wiki/doku.php?id=howto:embeding_a_php_source_into_a_windows_executable_file
//========================================================================

/* Standards includes */
#include <stdio.h>
#include <math.h>

/* PHP Defines */
#define ZEND_WIN32
#define PHP_WIN32
#define ZTS 1
#define ZEND_DEBUG 0

/* PHP Includes */
#ifdef __cplusplus
extern "C" {
#endif
	#include <php.h>
	#include <php_embed.h>
#ifdef __cplusplus
}
#endif

/* Main */
int main(int argc, char** argv) {
	zval ret_value;
	void ***tsrm_ls;
	int exit_status;
	char *eval_string= "include 'res:///PHP/RUN';"; // res:/// uses current image file, you can use res://some\path\to\file.exe/PHP/RUN

	php_embed_init(argc, argv PTSRMLS_CC);
	zend_first_try {
		PG(during_request_startup) = 0;
		zend_eval_string(eval_string, &ret_value, "main" TSRMLS_CC);
		exit_status= Z_LVAL(ret_value);
	}
	zend_catch {
		exit_status = EG(exit_status);
	}
	zend_end_try();
	php_embed_shutdown(TSRMLS_C);

	return exit_status;
}
